/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.UserEquivalenceValidation;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class NodeValidation {
    public static final String UNKNOWN_HOST = "ping: unknown host ";
    public static final String SUCC_MSG = "SUCCESS";
    public static final String ERROR_SINGLE_NODE = "FAILURE";
    public static final String ERROR_MULTIPLE_NODES = "ERROR";
    private static Logger logger = Logger.getLogger(NodeValidation.class.getName());

    public static String[] checkLiveliness(String[] nodeList, int timeout) {
        ArrayList<String> RetMsg;
        block8: {
            ArrayList<String> upNodes = new ArrayList<String>();
            ArrayList<String> errNodes = new ArrayList<String>();
            RetMsg = new ArrayList<String>();
            String CurrNode = "";
            boolean flag = false;
            try {
                ClusterCmd Ccmd = new ClusterCmd();
                flag = Ccmd.areNodesAlive(nodeList, timeout, null);
                if (!flag) break block8;
                RetMsg.add(SUCC_MSG);
            }
            catch (ClusterException ce) {
                RetMsg.add(ERROR_SINGLE_NODE);
            }
            catch (RemoteFileOperationException rfoe) {
                int i;
                RetMsg.add(ERROR_MULTIPLE_NODES);
                for (i = 0; i < nodeList.length; ++i) {
                    CurrNode = nodeList[i];
                    try {
                        int status = rfoe.getStatus(CurrNode);
                        if (status == 0) {
                            flag = true;
                            upNodes.add(CurrNode);
                        }
                        if (status != 1 && status != 2) continue;
                        errNodes.add(CurrNode);
                        continue;
                    }
                    catch (NoSuchNodeException nsne) {
                        flag = false;
                        RetMsg.add(UNKNOWN_HOST);
                    }
                }
                int DownNodeSz = errNodes.size();
                if (DownNodeSz <= 0) break block8;
                for (i = 0; i < DownNodeSz; ++i) {
                    RetMsg.add((String)errNodes.get(i));
                }
            }
        }
        String[] RetAry = RetMsg.toArray(new String[RetMsg.size()]);
        return RetAry;
    }

    public static void validateForBadCharacters(List<String> nodes) throws ValidationException {
        String strBadCharsFound = null;
        for (int iLoop = 0; iLoop < nodes.size(); ++iLoop) {
            strBadCharsFound = GenericValidation.validateBadCharGetString(" !@%^&*()+=\\|`~[{]};'\",<>/?#$:", nodes.get(iLoop));
            if (strBadCharsFound == null || strBadCharsFound.equals("")) continue;
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NODE_NAME_WITH_BAD_CHARACTERS, new Object[0]);
        }
    }

    public static void validateForIPs(List<String> nodes) throws ValidationException {
        for (int iLoop = 0; iLoop < nodes.size(); ++iLoop) {
            String strHostName = nodes.get(iLoop);
            if (strHostName == null || strHostName.length() <= 0 || !GenericValidation.validateIP(strHostName)) continue;
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NODE_IN_IP, new Object[0]);
        }
    }

    public static void validateUserEquivalence(List<String> nodes) throws ValidationException {
        String[] nodeList = nodes.toArray(new String[0]);
        logger.info("Validating Public nodes for user equivalence");
        if (!UserEquivalenceValidation.ensureUserEquivalence(nodeList)) {
            UserEquivalenceValidation equ = new UserEquivalenceValidation();
            String inactiveNodes = equ.getInactiveNodes();
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_USER_EQUIVALENCE_ERR, new Object[]{inactiveNodes});
        }
    }

    public static void validateNodesOnSameDomain(List<String> nodes) throws ValidationException {
        int iLoop;
        logger.info("Checking all nodes are on the same domain.");
        String strLocalDomainName = null;
        String strNodeDomain = null;
        try {
            strLocalDomainName = MachineInfo.getInstance().getDomainName(MachineInfo.getInstance().getFullHostName());
            logger.info("Local Domain Name: " + strLocalDomainName);
        }
        catch (InstallException e) {
            logger.info("Failed to get local node domain name");
            ValidationException ex = new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NODE_PUB_INVALID_ERR, new Object[0]);
            PlainContent details = new PlainContent(e.getLocalizedMessage());
            Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
            details.setTitle(resource.getString("EXCEPTION_DETAILS", "Exception Details:", new Object[0]));
            ex.getErrorInfo().setExtraDetails((Content)details);
            throw ex;
        }
        if (strLocalDomainName == null || strLocalDomainName.trim().length() == 0) {
            logger.warning("No Local Domain found, setting to whatever first domain is available");
            for (iLoop = 0; iLoop < nodes.size(); ++iLoop) {
                try {
                    strNodeDomain = MachineInfo.getInstance().getDomainName(nodes.get(iLoop));
                }
                catch (InstallException e) {
                    logger.log(Level.INFO, "Exception while getting the domain name of node", (Throwable)((Object)e));
                }
                if (strNodeDomain == null || strNodeDomain.length() == 0) continue;
                logger.info("Got the Domain name from:" + nodes.get(iLoop));
                strLocalDomainName = strNodeDomain;
                break;
            }
            logger.info("Local Domain set to:" + strLocalDomainName);
        }
        if (strLocalDomainName != null && strLocalDomainName.trim().length() > 0) {
            for (iLoop = 0; iLoop < nodes.size(); ++iLoop) {
                try {
                    strNodeDomain = MachineInfo.getInstance().getDomainName(nodes.get(iLoop));
                }
                catch (InstallException e) {
                    logger.warning("Invalid Host name:" + nodes.get(iLoop));
                    ValidationException ex = new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NODE_PUB_INVALID_ERR, new Object[0]);
                    PlainContent details = new PlainContent(e.getLocalizedMessage());
                    Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
                    details.setTitle(resource.getString("EXCEPTION_DETAILS", "Exception Details:", new Object[0]));
                    ex.getErrorInfo().setExtraDetails((Content)details);
                    throw ex;
                }
                if (strNodeDomain != null && strNodeDomain.length() > 0) {
                    if (strLocalDomainName.equalsIgnoreCase(strNodeDomain)) continue;
                    logger.warning("Domain name " + strNodeDomain + " for " + nodes.get(iLoop) + " different then local domain.");
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NODE_DIFF_DOMAIN_ERR, new Object[0]);
                }
                logger.info("Domain not found for: " + nodes.get(iLoop));
            }
        } else {
            logger.warning("No Domain found, skipping Same Domain validation");
        }
    }

    public static void validateForNodesWithStaleInventory(String[] nodes) throws ValidationException {
        if (!PlatformInfo.getInstance().isWindows()) {
            ArrayList<String> nodesWithStaleInventory = new ArrayList<String>();
            for (String node : nodes) {
                if (RemoteInventoryInfo.getInstance((String)node).isInventoryExists() || !FileInfo.getInstance().doesRemoteDirExist(node, InventoryInfo.getInstance().getDefaultInventoryLoc())) continue;
                nodesWithStaleInventory.add(node);
            }
            if (nodesWithStaleInventory.size() > 0) {
                throw new ValidationException((ErrorCode)CommonErrorCode.REMOTE_NODE_HAS_STALE_INVETORY, new Object[]{((Object)nodesWithStaleInventory).toString(), InventoryInfo.getInstance().getDefaultInventoryLoc()});
            }
        }
    }

    public static List<String> getLiveNodes(List<String> nodes, int timeout) {
        ArrayList<String> aliveNodes = new ArrayList<String>();
        String[] strReturn = null;
        for (String node : nodes) {
            strReturn = NodeValidation.checkLiveliness(new String[]{node}, timeout);
            if (strReturn == null || strReturn.length == 0 || !strReturn[0].equals(SUCC_MSG)) continue;
            aliveNodes.add(node);
        }
        return aliveNodes;
    }
}

